#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Marched Log SphericalMod01.fsh   by   byt3_m3chanic 
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/**
    Log Spherical Mapping / Log Polar Coords
    @byt3_m3chanic 08/20/21
    
    Found this post online and started to try some of
    it out in 2D and 3D. I hope I got this kind
    of right.. some guessing about a few of the
    numbers used. (mouseable)

    also I need to branch out into other tile systems,
    truchets are easy to set up - but what are other good
    examples with square tiled grids.
    
    https://www.osar.fr/notes/logspherical/
    
*/

#define R           iResolution
#define T           iTime
#define M           iMouse

#define PI          3.14159265359
#define PI2         6.28318530718

#define MAX_DIST    30.00
#define MIN_DIST    0.001

float hash21(vec2 a){ return fract(sin(dot(a, vec2(27.609, 57.583)))*43758.5453); }
mat2 rot(float a) { return mat2(cos(a),sin(a),-sin(a),cos(a)); }

//@iq https://iquilezles.org/articles/palettes
vec3 hue(float t){ 
    vec3 d = vec3(0.110,0.584,0.949);
    return .45+.4*cos( PI2*t*vec3(.95,.97,.88)*d ); 
}

//@iq cylinder	
float box(vec3 p, vec3 b) {
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

const float sz = 2.;
const float hl = sz*.5;
const vec2 boxSize = vec2(sz*.465 ,.25);
const float density = 16.;

//global
vec3 hit,ghp;
vec2 cellId,gid;
float lpscale,movement;
mat2 turn;

vec2 map(vec3 q){
    vec2 res = vec2(1e5,0.);

    vec2 p = q.xz;
    p*=turn;
    float r = length(p);
	p = vec2(log(r), atan(p.y, p.x));

	p *= lpscale;
	float mul = r/lpscale;
    p.y -= hl;
    
    p.x += .0 + movement;
    
    vec2 id = floor((p+hl)/sz) - 1.5;
    p = mod(p+hl,sz)-hl;

    vec3 lp = vec3(p.x, max(0.0, q.y/mul), p.y);
    
    float bx = box(lp,boxSize.xyx)-.035;
    if(bx<res.x) {
        res = vec2(bx*mul,2.);
        gid = id;
        ghp = lp;
    }
   
    return res;
}

// Tetrahedron technique @iq
// https://iquilezles.org/articles/normalsSDF
vec3 normal(vec3 p, float t)
{
    float e = MIN_DIST*t;
    vec2 h =vec2(1,-1)*.5773;
    vec3 n = h.xyy * map(p+h.xyy*e).x+
             h.yyx * map(p+h.yyx*e).x+
             h.yxy * map(p+h.yxy*e).x+
             h.xxx * map(p+h.xxx*e).x;
    return normalize(n);
}
vec3 truchet(vec2 vuv) {

    float px = fwidth(length(vuv)/PI);

    vec2 id   = cellId;
    vec2 grid = vuv;
    
    float hs = hash21(id);
    if(hs>.5) grid.x*=-1.;
    
    vec3 h = vec3(0); 
    vec3 bc = vec3(1);
    
    float chk = mod(id.y + id.x,2.) * 2. - 1.;

    vec2 d2 = vec2(length(grid-hl), length(grid+hl));
    vec2 gx = d2.x<d2.y? vec2(grid-hl) : vec2(grid+hl);

    float circle = length(gx)-hl;
    float circle2 = abs(abs(circle)-.125)-(.085+.065*sin(vuv.x*3.25) );
    circle2=abs(abs(circle2)-.04)-.02;
    circle2=smoothstep(-px,px,circle2);
    
    // color flip for every other one and then ones 
    // thats are flipped by the hash
    circle=(chk>0.^^ hs>.5) ? smoothstep(-px,px,circle) : smoothstep(px,-px,circle);
    
    vec2 sx = abs(grid)-hl;
    float cbx = length(sx)-.35;
    cbx=abs(abs(cbx)-.075)-(.025+.015*sin(vuv.x*3.25));
    cbx=smoothstep(px,-px,cbx);
    h = mix(h, bc, min(circle2,circle));
    h = mix(h, bc, cbx);
    return h;
}

//void mainImage( out vec4 O, in vec2 F )
#define fragColor O
#define fragCoord F
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 O, in vec2 F )
{
    // pre-cal
    lpscale = floor(density)/PI;
    movement = iTime*lpscale * .123;
    turn = rot(T*5.*PI/180.);
    //
    
    
    vec2 uv = (2.* F.xy-R.xy)/max(R.x,R.y);

    vec3 ro = vec3(0, 0, 8);
    vec3 rd = normalize(vec3(uv, -1.0));
    
    // mouse //
    float x = M.xy==vec2(0) ? 0. : -(M.y/R.y*.25-.125)*PI;
    float y = M.xy==vec2(0) ? 0. : -(M.x/R.x*.5-.25)*PI;
    mat2 rx =rot((-.75+.2*sin(T*.1))+x);
    mat2 ry =rot((.8*sin(T*.3))+y);
    ro.zy*=rx;rd.zy*=rx;
    ro.xz*=ry;rd.xz*=ry;

    vec3 C = vec3(0);
    float m = 0.;
    float d = 0.;
    vec3 p = ro;
    
    for(int i=0;i<100;i++)
    {
        p = ro + rd * d;
        vec2 ray = map(p);
        if(abs(ray.x)<MIN_DIST*d||d>MAX_DIST)break;
        d += i<64? ray.x*.5: ray.x;
        m  = ray.y;
    } 

    hit = ghp;
    cellId = gid;
    
    float alpha = 0.;
    if(d<MAX_DIST)
    {
        vec3 n = normal(p,d);
        vec3 lpos =  vec3(0,8,.5)*lpscale;
        vec3 l = normalize(lpos-p);

        float diff = clamp(dot(n,l),0.,1.);
        vec3 view = normalize(p - ro);
        vec3 ret = reflect(normalize(lpos), n);
        float spec =  0.75 * pow(max(dot(view, ret), 0.), 24.);

        vec3 h = vec3(.05);
  
        if(m==2.) h = truchet(hit.xz)* hue(cellId.x*.1);

        C = h * diff + spec;
    }
    C = mix(vec3(.0),C,exp(-.0015*d*d*d));
    
    C=pow(C, vec3(.4545));
    // Output to screen
    fragColor = vec4(C,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

